'
' Egzemplarze tej klasy odpowiadaj za analiz skadniow maego jzyka kombinacji wyrazw.
'
Public Class Parser
    Private lexer As LexicalAnalyzer ' lexical analyzer that parser uses
    Private token As LexicalAnalyzer.Id

    '
    ' Metoda Parse dokonuje analizy skadniowej kombinacji sw odczytanych z
    ' danego przekazanego za porednictwem jej argumentu strumienia wejciowego.
    '
    ' input  Strumie strumie wejciowy, z ktrego ta metoda odczytuje dane rdowe
    '         zapisane w maym jzyku kombinacji wyrazw.
    ' zwraca  Obiekt obiekt kombinacji wyrazw reprezentujcy korze drzewa analizy
    '          skadniowej zbudowanego przez ten analizator.
    Public Function Parse(ByVal input As System.IO.StreamReader) As ICombination
        lexer = New LexicalAnalyzer(input)
        Dim c As ICombination = orCombination()
        Expect(LexicalAnalyzer.Id.Eof)
        Return c
    End Function 'Parse

    ' Analiza skadniowa tokenu orCombination
    Public Function orCombination() As ICombination
        Dim c As ICombination = andCombination()
        While token = LexicalAnalyzer.Id.Or
            c = New OrCombination(c, andCombination())
        End While
        Return c
    End Function 'orCombination

    ' Analiza skadniowa tokenu andCombination
    Public Function andCombination() As ICombination
        Dim c As ICombination = nearCombination()
        While token = LexicalAnalyzer.Id.And
            c = New AndCombination(c, nearCombination())
        End While
        Return c
    End Function 'andCombination

    ' Analiza skadniowa tokenu nearCombination
    Public Function nearCombination() As ICombination
        Dim c As ICombination = simpleCombination()
        While token = LexicalAnalyzer.Id.Near
            c = New NearCombination(c, simpleCombination())
        End While
        Return c
    End Function 'nearCombination

    ' Analiza skadniowa tokenu simpleCombination
    Public Function simpleCombination() As ICombination
        If token = LexicalAnalyzer.Id.LeftParen Then
            nextToken()
            Dim c As ICombination = orCombination()
            Expect(LexicalAnalyzer.Id.RightParen)
            Return c
        End If
        If token = LexicalAnalyzer.Id.Not Then
            Return notWordCombination()
        Else
            Return wordCombination()
        End If
    End Function 'simpleCombination

    ' Analiza skadniowa tokenu wordCombination
    Public Function wordCombination() As ICombination
        If token <> LexicalAnalyzer.Id.Word And token <> LexicalAnalyzer.Id.QuotedString Then
            ' Wywietla komunikat o bdzie i generuje wyjtek typu SyntaxException.
            Expect(LexicalAnalyzer.Id.Word)
        End If
        Dim c As New WordCombination(lexer.StringValue)
        nextToken()
        Return c
    End Function 'wordCombination

    ' Analiza skadniowa tokenu wordCombination
    Public Function notWordCombination() As ICombination
        Expect(LexicalAnalyzer.Id.Not)
        If token <> LexicalAnalyzer.Id.Word And token <> LexicalAnalyzer.Id.QuotedString Then
            ' Wywietla komunikat o bdzie i generuje wyjtek typu SyntaxException.
            Expect(LexicalAnalyzer.Id.Word)
        End If
        Dim c As New NotWordCombination(lexer.StringValue)
        nextToken()
        Return c
    End Function 'notWordCombination

    ' Zwraca nastpny token z analizatora leksykalnego.
    Public Sub nextToken()
        token = lexer.NextToken()
    End Sub 'nextToken

    '
    ' Genetuje komunikat o bdzie i wyjtek, jeli typ biecego tokenu jest
    ' niezgodny z oczekiwanym typem.
    '
    Public Sub Expect(ByVal t As LexicalAnalyzer.Id)
        If token <> t Then
            Dim msg As String = "znaleziono " & tokenName(token) & "; oczekiwano " & tokenName(t)
            Throw New System.ApplicationException(msg)
        End If
        nextToken()
    End Sub 'Expect
End Class 'Parser
